
/**********************Document Ready****************************************/

$(document).ready(function(){
    
    /*****************************Graph Data*********************************/
    getAllStudentdetails();
    function displaygraph(xlabels,ylabels,typed,catdetails){    
        var ctx = document.getElementById("assignment_performance").getContext('2d');
        const assignment_performance = new Chart(ctx, {
            type: 'bar',
            data: {
            //["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
            labels: xlabels,
            datasets: [{
                    label: catdetails,
                    data: ylabels,
                    backgroundColor: [
                    'rgba(255, 99, 132, 1)',
                    'rgba(54, 162, 235, 1)',
                    'rgba(255, 206, 86, 1)',
                    'rgba(75, 192, 192, 1)',
                    'rgba(74, 173, 33, 1)',
                    'rgba(255, 159, 64, 1)',
                    'rgba(230, 238, 52, 1)',
                    'rgba(33, 215, 139, 1)',
                    'rgba(191, 0, 255, 1)',
                    'rgba(75, 192, 192, 1)',
                    'rgba(132, 99, 255, 1)',
                    'rgba(241, 31, 81, 1)'
                    ],
                    borderColor: [
                    'rgba(255, 99, 132, 1)',
                    'rgba(54, 162, 235, 1)',
                    'rgba(255, 206, 86, 1)',
                    'rgba(75, 192, 192, 1)',
                    'rgba(74, 173, 33, 1)',
                    'rgba(255, 159, 64, 1)',
                    'rgba(230, 238, 52, 1)',
                    'rgba(33, 215, 139, 1)',
                    'rgba(191, 0, 255, 1)',
                    'rgba(75, 192, 192, 1)',
                    'rgba(132, 99, 255, 1)',
                    'rgba(241, 31, 81, 1)'
                    ],
                    borderWidth: 1
            }]
            },
            options: {
                scales: {
                xAxes: [{
                    barThickness: 14,  // number (pixels) or 'flex'
                    maxBarThickness: 20, // number (pixels)
                    barPercentage: 0.5
                }],
                yAxes: [{
                    ticks: {
                        beginAtZero: true,
                        suggestedMin: 0,
                        suggestedMax: 100
                    }
                }]
                }
            }
            });
    }
    
    /*****************************Display student*************************/
    
    function getAllStudentdetails(){
        const xlabels=[];
        const ylabels=[];
        $type = "Student";
        $.ajax({
            url: "assets/php/preport.php",
            method:"POST",
            dataType:"json",
            data:{"type":$type},
            success:function(data){
                $.each(data,function(i,row){
                    $.each(row,function(id,rowd){
                        $monthd = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
                        $month = $monthd[id];
                        xlabels.push($month);
                        $prospectd = rowd;
                        ylabels.push($prospectd);
                        $typed = "student_performance";
                        $type = 'Student';
                        displaygraph(xlabels,ylabels,$typed,$type);
                        console.log($month+":"+$prospectd);
                    });
                });
            },
            error:function(data){
            }
        });
    }
        
    /*****************************Display Teacher*************************/
    
    getAllTeacher();
    function getAllTeacher(){
        $type = "AdminDashboard";
        $.ajax({
            url: "assets/php/dashboarddetails.php",
            method:"POST",
            dataType:"json",
            data:{"type":$type},
            success:function(data){
                $('#teachercount').text(data);
            },
            error:function(data){
            }
        });
    }
    
    /*****************************Display Student*************************/
    
    getAllStudent();
    function getAllStudent(){
        $type = "Student";
        $.ajax({
            url: "assets/php/dashboarddetails.php",
            method:"POST",
            dataType:"json",
            data:{"type":$type},
            success:function(data){
                $('#studentcount').text(data);
            },
            error:function(data){
            }
        });
    }
    
    /*****************************Display Prospect*************************/
    
    getAllProspect();
    function getAllProspect(){
        $type = "Prospect";
        $.ajax({
            url: "assets/php/dashboarddetails.php",
            method:"POST",
            dataType:"json",
            data:{"type":$type},
            success:function(data){
                $('#prospectcount').text(data);
            },
            error:function(data){
            }
        });
    }
    
    /*****************************Go to Event*************************/
    
    $('.addevent').on("click",function(){
        $(location).prop('href', 'upcomingevents.php');
    });
                                             
});