
/**********************Document Ready****************************************/

$(document).ready(function(){
    
    /*****************************Graph Data*********************************/
    
    $urldetails = $(location).attr('href');
    $searchd = "admin/addstudent.php";
    
    if($urldetails.indexOf($searchd) != -1){
        displayratio();
        getAllStudent();
    }else{
        getAllProspect();
        getAllStudent();
        displayratio();
        displayAllcategory();
        chart();
    }
        
    function displayprofilegraph(xlabels,ylabels,typed,catdetails){  
        const ctx = document.getElementById(typed).getContext('2d');
        const prospect_performance = new Chart(ctx, {
            type: 'bar',
            data: {
            //["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
            labels: xlabels,
            datasets: [{
                    label: catdetails,
                    data: ylabels,
                    backgroundColor: [
                    'rgba(255, 99, 132, 1)',
                    'rgba(54, 162, 235, 1)',
                    'rgba(255, 206, 86, 1)',
                    'rgba(75, 192, 192, 1)',
                    'rgba(74, 173, 33, 1)',
                    'rgba(255, 159, 64, 1)',
                    'rgba(230, 238, 52, 1)',
                    'rgba(33, 215, 139, 1)',
                    'rgba(191, 0, 255, 1)',
                    'rgba(75, 192, 192, 1)',
                    'rgba(132, 99, 255, 1)',
                    'rgba(241, 31, 81, 1)'
                    ],
                    borderColor: [
                    'rgba(255, 99, 132, 1)',
                    'rgba(54, 162, 235, 1)',
                    'rgba(255, 206, 86, 1)',
                    'rgba(75, 192, 192, 1)',
                    'rgba(74, 173, 33, 1)',
                    'rgba(255, 159, 64, 1)',
                    'rgba(230, 238, 52, 1)',
                    'rgba(33, 215, 139, 1)',
                    'rgba(191, 0, 255, 1)',
                    'rgba(75, 192, 192, 1)',
                    'rgba(132, 99, 255, 1)',
                    'rgba(241, 31, 81, 1)'
                    ],
                    borderWidth: 1
            }]
            },
            options: {
            scales: {
            xAxes: [{
                barThickness: 14,  // number (pixels) or 'flex'
                maxBarThickness: 20, // number (pixels)
                barPercentage: 0.5
            }],
            yAxes: [{
                ticks: {
                    beginAtZero: true,
                    suggestedMin: 0,
                    suggestedMax: 100
                }
            }]
            }
            }
            });
    }
    
    function displayratio(){
        var ctxP = document.getElementById("pieChart").getContext('2d');
        var myPieChart = new Chart(ctxP, {
        type: 'pie',
        data: {
        labels: ["Red", "Green", "Yellow", "Grey", "Dark Grey"],
        datasets: [{
        data: [300, 50, 100, 40, 120],
        backgroundColor: ["#F7464A", "#46BFBD", "#FDB45C", "#949FB1", "#4D5360"],
        hoverBackgroundColor: ["#FF5A5E", "#5AD3D1", "#FFC870", "#A8B3C5", "#616774"]
        }]
        },
        options: {
        responsive: true
        }
        });
    }
    
    function displayAllcategory(){
        var ctxP = document.getElementById("getChart").getContext('2d');
        var myPieChart = new Chart(ctxP, {
          plugins: [ChartDataLabels],
          type: 'pie',
          data: {
            labels: ["Prospect", "Student", "Teacher"],
            datasets: [{
              data: [210, 130, 120],
              backgroundColor: ["#F7464A", "#46BFBD", "#FDB45C"],
              hoverBackgroundColor: ["#FF5A5E", "#5AD3D1", "#FFC870"]
            }]
          },
          options: {
            responsive: true,
            legend: {
              position: 'right',
              labels: {
                padding: 20,
                boxWidth: 10
              }
            },
            plugins: {
              datalabels: {
                formatter: (value, ctx) => {
                  let sum = 0;
                  let dataArr = ctx.chart.data.datasets[0].data;
                  dataArr.map(data => {
                    sum += data;
                  });
                  let percentage = (value * 100 / sum).toFixed(2) + "%";
                  return percentage;
                },
                color: 'white',
                labels: {
                  title: {
                    font: {
                      size: '16'
                    }
                  }
                }
              }
            }
          }
        });
    }
    
    function chart(){
        var ctxP = document.getElementById("labelChart").getContext('2d');
        var myPieChart = new Chart(ctxP, {
          plugins: [ChartDataLabels],
          type: 'pie',
          data: {
            labels: ["Prospect", "Student", "Teacher"],
            datasets: [{
              data: [210, 130, 120],
              backgroundColor: ["#F7464A", "#46BFBD", "#FDB45C"],
              hoverBackgroundColor: ["#FF5A5E", "#5AD3D1", "#FFC870"]
            }]
          },
          options: {
            responsive: true,
            legend: {
              position: 'right',
              labels: {
                padding: 20,
                boxWidth: 10
              }
            },
            plugins: {
              datalabels: {
                formatter: (value, ctx) => {
                  let sum = 0;
                  let dataArr = ctx.chart.data.datasets[0].data;
                  dataArr.map(data => {
                    sum += data;
                  });
                  let percentage = (value * 100 / sum).toFixed(2) + "%";
                  return percentage;
                },
                color: 'white',
                labels: {
                  title: {
                    font: {
                      size: '16'
                    }
                  }
                }
              }
            }
          }
        });
    }
        
    /*****************************Display prospect*************************/
    
    function getAllProspect(){
        const xlabels=[];
        const ylabels=[];
        $type = "Prospect";
        $.ajax({
            url: "assets/php/preport.php",
            method:"POST",
            dataType:"json",
            data:{"type":$type},
            success:function(data){
                $.each(data,function(i,row){
                    $.each(row,function(id,rowd){
                        $monthd = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
                        $month = $monthd[id];
                        xlabels.push($month);
                        $prospectd = rowd;
                        ylabels.push($prospectd);
                        $typed = "prospect_performance";
                        $type = 'Prospect';
                        displayprofilegraph(xlabels,ylabels,$typed,$type);
                        console.log($month+":"+$prospectd);
                    });
                });
            },
            error:function(data){
            }
        });
    }
    
    /*****************************Display student*************************/
    
    function getAllStudent(){
        const xlabels=[];
        const ylabels=[];
        $type = "Student";
        $.ajax({
            url: "assets/php/preport.php",
            method:"POST",
            dataType:"json",
            data:{"type":$type},
            success:function(data){
                $.each(data,function(i,row){
                    $.each(row,function(id,rowd){
                        $monthd = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
                        $month = $monthd[id];
                        xlabels.push($month);
                        $prospectd = rowd;
                        ylabels.push($prospectd);
                        $typed = "student_performance";
                        $type = 'Student';
                        displayprofilegraph(xlabels,ylabels,$typed,$type);
                    });
                });
            },
            error:function(data){
            }
        });
    }
    
});